/**
* \file: partition_fsm.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_PARTITION_FSM_H
#define AAM_CONTROL_PARTITION_FSM_H

#include "model/device.h"
#include "control/mount.h"

typedef void (*partition_request_done_cb_t)(partition_t *partition, void *data, error_code_t result);

void partition_fsm_enter_unsupported(partition_t *partition,
		partition_unsupported_reason_t unsupported_reason);

void partition_fsm_enter_mounting(partition_t *partition,
		const char* mount_point);

void partition_fsm_signal_part_removed(partition_t *partition);

error_code_t partition_fsm_signal_unmount_request(partition_t *partition,
        partition_state_change_callback_t callback_func, void *callback_data);

error_code_t partition_fsm_signal_remount_request(partition_t *partition,
		const mount_options_t *options, partition_state_change_callback_t callback_func, void *callback_data);

#endif
